
#define COLLISION_SWITCH 4
#define IR_SENSOR 3
#define RANGE_SENSOR A1

void setup() {
  // tutaj powinien się znaleźć kod inicjalizacji, który uruchamiamy tylko raz:
  Serial.begin(9600);
  pinMode(COLLISION_SWITCH, INPUT);
  pinMode(IR_SENSOR, INPUT);
}

void loop() {
  // tutaj powinien się znaleźć główny kod, który uruchamia się wielokrotnie: 
  int collisionValue = digitalRead(COLLISION_SWITCH);
  if (isnan(collisionValue)) {
    Serial.println(" Błąd odczytu czujnika zderzeniowego");
    return;
  }
  if (collisionValue == LOW) {
    Serial.println("Wykryto kolizję");
  }

  int irValue = digitalRead(IR_SENSOR);
  if (isnan(irValue)) {
    Serial.println(" Niepowodzenie odczytu czujnika podczerwieni");
    return;
  }
  if (irValue == LOW) {
    Serial.println("Wykryto promieniowanie IR");
  }

  int anVolt = analogRead(RANGE_SENSOR);
  if (isnan(anVolt)) {
    Serial.println(" Błąd odczytu czujnika odległości");
    return;
  }
  int mm = anVolt*5; 
  float inch = mm/25.4;
  Serial.print("W metrach:      ");
  Serial.println(mm);
  Serial.print("W calach:  ");
  Serial.println(inch);
  Serial.println("---------------------------");
  delay(1000);
}
